/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition ( scaled_gl_FragCoord.xy / u_WindowSize - vec2(0.5) )

/////////////////////////////////////////////////////////////////////////////////
 
#define topart
#define angle 3.14159/5.5;
#define constant vec2(1.25)

#ifdef GL_ES
precision highp float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// varying vec2 surfacePosition;

vec3 hsv(float h,float s,float v) {
	return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v;
}
vec2 cmul(vec2 a, vec2 b) {
    return vec2(a.x*b.x - a.y*b.y, a.x*b.y + a.y*b.x);
}

void main( void ) {

	vec2 p = surfacePosition+vec2(0.0,1.25);
	p /= dot(p,p);
	p = p/2.5-vec2(0.625,-0.5);
	float a = 0.61;
	float s = sin(a*mix(0.9,1.1,sin(time*1.00002)*sin(time)));
	float c = cos(a*.95);
	vec3 col = fract(time*7.)<.2?vec3(0.0):vec3(time/2.0 + sin(time)*cos(time));
	for (int i = 0; i < 200; i++) {
		if (dot(p, p) > 4.0) {
		    col *= 4.0; 
		    break;
		}
		p = cmul(p, p) + p * constant;
		p = -abs(p);
		p = vec2(-s*p.y+c*p.x, s*p.x+c*p.y);
		p = -abs(p.yx);
		col += hsv(dot(p,p)*(fract(time)*6.), 1., 0.08);
		
	}

	gl_FragColor = vec4( sin(col), 200.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}